<?php

namespace Digits\SocialLogin\Auths;

use DigitsSocialOAuth2;

class FacebookAuth extends SocialLoginAuth
{
    private $client_id;
    private $redirect_url;
    private $icon_only;
    private $settings;
    const APP_VERSION = 'v16.0';

    function __construct($settings, $social_info, $icon_only)
    {
        $this->settings = $settings;
        $this->client_id = esc_attr($settings['clientID']);
        $this->redirect_url = $social_info['redirect_uri'];
        $this->icon_only = $icon_only;
        parent::__construct();
    }


    public function show_connect_with()
    {
        return !empty($this->settings['showContinueAs']);
    }

    public function render()
    {
        if (!$this->show_connect_with()) {
            $this->default_layout('digits_facebook_login', 'Facebook');
        } else {
            ?>
            <div class="fb-login-button"
                 data-width="100%" data-size="large"
                 data-button-type="continue_with"
                 data-layout="default" data-auto-logout-link="false"
                 data-use-continue-as="true"
                 data-scope="public_profile,email"
                 onlogin="digits_processFacebookLogin();"></div>
            <input type="hidden" class="digits_facebook_login"
                   value="<?php echo esc_attr(wp_create_nonce('facebook_login')); ?>">
            <?php
        }
    }

    public function get_url()
    {
        $query = [
            'client_id' => urlencode($this->client_id),
            'scope' => 'public_profile,email',
            'response_type' => 'code',
            'redirect_uri' => urlencode($this->redirect_url),
            'state' => wp_create_nonce('facebook_login'),
        ];
        $base_url = 'https://www.facebook.com/' . self::APP_VERSION . '/dialog/oauth';
        return add_query_arg($query, $base_url);
    }

    public function enqueue_scripts()
    {
        if ($this->show_connect_with()) {

            $url = 'https://connect.facebook.net/' . get_locale() . '/sdk.js#xfbml=1&version=' . self::APP_VERSION . '&appId=' . $this->client_id . '&autoLogAppEvents=1';
            wp_enqueue_script('facebook-oauth', $url);

        }
    }

    public function process_token()
    {
    }


    public function process_oauth_token()
    {
        if (empty($_REQUEST['code'])) {
            $this->invalid_info();
            die();
        }

        if (!wp_verify_nonce($_REQUEST['state'], 'facebook_login')) {
            $this->nonce_fail();
            die();
        }

        try {

            $code = $_REQUEST['code'];

            $client = new DigitsSocialOAuth2\Client($this->client_id, $this->settings['clientSecretID']);

            if (!$this->show_connect_with()) {
                $accessTokenUrl = 'https://graph.facebook.com/oauth/access_token';
                $params = array("code" => $code, "redirect_uri" => $this->redirect_url);
                $response = $client->getAccessToken($accessTokenUrl, "authorization_code", $params);

                $accessTokenResult = $response["result"];
                $access_token = $accessTokenResult["access_token"];
            } else {
                $access_token = $code;
            }

            if (empty($access_token)) {
                $this->invalid_info();
                die();
            }

            $client->setAccessToken($access_token);
            $client->setAccessTokenType(DigitsSocialOAuth2\Client::ACCESS_TOKEN_BEARER);

            $response = $client->fetch("https://graph.facebook.com/me?fields=name,email");

            $response = $response['result'];
            
            $name = $response['name'];
            $username = $response['name'];
            $discord_id = $response['id'];

            $email = '';
            if (!empty($response['email'])) {
                $email = $response['email'];
            }

            $response = digits_social_create_user($name, $email, 'facebook', $username, $discord_id);

            $this->success_view($response);
        } catch (\Exception $e) {
            $this->error_view($e);
        }

    }
}
